/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.monazilla.v2c.V2CDatePanel;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CDateSelector
extends JPanel
implements Runnable,
MouseListener {
    SimpleDateFormat sdfDateFormat;
    Date dMinimumDate;
    int iMinYear;
    Date dCurrentDate;
    JTextField jtfDate;
    JLabel jlDate;
    ActionListener alDateChangeListener;

    public V2CDateSelector(Date date, Date date2, boolean bl) {
        this(date, date2, bl, null);
    }

    public V2CDateSelector(Date date, Date date2, boolean bl, ActionListener actionListener) {
        super(new GridBagLayout());
        JLabel jLabel;
        JTextField jTextField;
        this.sdfDateFormat = new SimpleDateFormat(bl ? "yyyy/MM/dd(E)" : "MM/dd(E)", Locale.JAPANESE);
        this.dCurrentDate = date;
        this.dMinimumDate = date2;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        this.iMinYear = calendar.get(1);
        this.alDateChangeListener = actionListener;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jtfDate = jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        jTextField.setHorizontalAlignment(4);
        String string = this.sdfDateFormat.format(date);
        jTextField.setText(string);
        Insets insets = jTextField.getInsets();
        Insets insets2 = jTextField.getMargin();
        Rectangle2D rectangle2D = jTextField.getFont().getStringBounds(string, new FontRenderContext(null, false, false));
        jTextField.setPreferredSize(new Dimension((int)rectangle2D.getWidth() + 4 + insets.left + insets.right + insets2.left + insets2.right, (int)rectangle2D.getHeight() + 1 + insets.top + insets.bottom + insets2.top + insets2.bottom));
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.add((Component)jTextField, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jlDate = jLabel = new JLabel(V2CSwingUtil.getSystemIcon("arset"));
        jLabel.addMouseListener(this);
        jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 1, 2, 1)));
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 3;
        this.add((Component)jLabel, gridBagConstraints);
    }

    public void run() {
        Date date = this.dCurrentDate;
        V2CDatePanel v2CDatePanel = new V2CDatePanel(date, this.iMinYear);
        Date date2 = v2CDatePanel.showDialog(this, "\u958b\u59cb");
        if (date2 == null || date2.compareTo(this.dMinimumDate) < 0) {
            return;
        }
        this.dCurrentDate = date2;
        this.jtfDate.setText(this.sdfDateFormat.format(date2));
        if (this.alDateChangeListener != null) {
            this.alDateChangeListener.actionPerformed(new ActionEvent(this, 1001, null));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component.isEnabled() && component == this.jlDate) {
            EventQueue.invokeLater(this);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setEnabled(boolean bl) {
        this.jtfDate.setEnabled(bl);
        this.jlDate.setEnabled(bl);
    }

    void setDate(long l) {
        Date date;
        if (l <= 0L) {
            return;
        }
        this.dCurrentDate = date = new Date(l);
        this.jtfDate.setText(this.sdfDateFormat.format(date));
    }

    Date getDate() {
        return this.dCurrentDate;
    }
}

