/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.monazilla.v2c.V2CPopupListener;

public class V2CCoveredComboBox
extends JPanel
implements LayoutManager,
LayoutManager2,
MouseInputListener,
PopupMenuListener {
    JComboBox jComboBox;
    JPanel jGlassPanel;
    long ltLastInvisible;
    Component cmpTarget;
    V2CPopupListener vPopupListener;

    public V2CCoveredComboBox(JComboBox jComboBox) {
        this(jComboBox, null);
    }

    public V2CCoveredComboBox(JComboBox jComboBox, V2CPopupListener v2CPopupListener) {
        super(null);
        this.jComboBox = jComboBox;
        this.vPopupListener = v2CPopupListener;
        this.jGlassPanel = new JPanel();
        this.jGlassPanel.addMouseListener(this);
        this.jGlassPanel.addMouseMotionListener(this);
        this.jGlassPanel.setOpaque(false);
        this.add(this.jGlassPanel);
        jComboBox.addPopupMenuListener(this);
        this.add(jComboBox);
        this.setLayout(this);
    }

    void layoutComboBoxDone() {
        int n;
        int n2 = this.jComboBox.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.jComboBox.getComponent(n);
            if (!(component instanceof JButton)) continue;
            Rectangle rectangle = component.getBounds();
            if (rectangle.width <= 0 || rectangle.height <= 0) continue;
            this.jGlassPanel.setBounds(rectangle);
            return;
        }
        n = this.getWidth();
        int n3 = this.getHeight();
        this.jGlassPanel.setBounds(n - n3, 0, n3, n3);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.jComboBox.getPreferredSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.jComboBox.getMinimumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            this.jComboBox.setBounds(0, 0, n, n2);
            this.jGlassPanel.setBounds(0, 0, n, n2);
        }
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.jComboBox.getMaximumSize();
    }

    public float getLayoutAlignmentX(Container container) {
        return this.jComboBox.getAlignmentX();
    }

    public float getLayoutAlignmentY(Container container) {
        return this.jComboBox.getAlignmentY();
    }

    public void invalidateLayout(Container container) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, true);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, true);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (System.currentTimeMillis() > this.ltLastInvisible + 10L) {
            this.redispatchMouseEvent(mouseEvent, true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, false);
        this.cmpTarget = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, false);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, true);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, false);
    }

    private void redispatchMouseEvent(MouseEvent mouseEvent, boolean bl) {
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.jComboBox);
        if (bl || this.cmpTarget == null) {
            this.cmpTarget = SwingUtilities.getDeepestComponentAt(this.jComboBox, (int)point.getX(), (int)point.getY());
        }
        if (this.cmpTarget == null) {
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            this.vPopupListener.showPopup(mouseEvent);
        }
        if (mouseEvent.getButton() != 3) {
            Point point2 = SwingUtilities.convertPoint(this.jComboBox, point, this.cmpTarget);
            this.cmpTarget.dispatchEvent(new MouseEvent(this.cmpTarget, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), point2.x, point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.ltLastInvisible = System.currentTimeMillis();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }
}

