/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.monazilla.v2c.V2CCenterLayout;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMouseExitListener;

public class V2CCenterPanel
extends JPanel
implements ActionListener {
    static Timer tTimer;
    JComponent jcContent;
    JPanel jpLeft = this.createJPanel(true);
    JPanel jpRight;
    boolean bMouseOnLeft;
    MouseExitListener melListener;
    static /* synthetic */ Class class$org$monazilla$v2c$V2CWritePanel;

    static void popupDelayChanged() {
        Timer timer = tTimer;
        if (timer != null) {
            if (timer.isRunning()) {
                timer.stop();
            }
            tTimer = null;
        }
    }

    public V2CCenterPanel() {
        super(new V2CCenterLayout());
        this.add(this.jpLeft);
        this.jpRight = this.createJPanel(false);
        this.add(this.jpRight);
    }

    private JPanel createJPanel(boolean bl) {
        MouseExitListener mouseExitListener;
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setVisible(false);
        this.melListener = mouseExitListener = new MouseExitListener(bl);
        mouseExitListener.addListeners(jPanel);
        DropTarget dropTarget = new DropTarget(jPanel, new DnDListener(bl));
        return jPanel;
    }

    void setPopupEnabled() {
        this.jpLeft.setVisible(V2CMain.canPopupTreePane(true));
        this.jpRight.setVisible(V2CMain.canPopupTreePane(false));
        this.layoutPanes();
    }

    void addContent(JComponent jComponent) {
        this.jcContent = jComponent;
        this.add(jComponent);
        this.melListener.setParent(jComponent);
    }

    void removeContent(JComponent jComponent) {
        if (jComponent == this.jcContent) {
            this.jcContent = null;
        }
        this.remove(jComponent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        V2CMain.popupTreePane(this.bMouseOnLeft);
    }

    void startPopupTimer(boolean bl) {
        Timer timer = tTimer;
        if (timer != null) {
            int n = timer.getInitialDelay();
            if (n != V2CMain.nPopupTreePaneDelay) {
                timer.setInitialDelay(V2CMain.nPopupTreePaneDelay);
            }
        } else {
            timer = new Timer(V2CMain.nPopupTreePaneDelay, this);
            timer.setRepeats(false);
            tTimer = timer;
        }
        if (!timer.isRunning()) {
            this.bMouseOnLeft = bl;
            timer.start();
        }
    }

    void stopPopupTimer() {
        Timer timer = tTimer;
        if (timer != null && timer.isRunning()) {
            timer.stop();
        }
    }

    void doLayoutWorks() {
        if (this.jcContent != null) {
            this.jcContent.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
        this.layoutPanes();
    }

    private void layoutPanes() {
        int n = this.getHeight();
        if (this.jpLeft.isVisible()) {
            this.jpLeft.setBounds(0, 0, V2CMain.nPopupTreePaneLWidth, n);
        }
        if (this.jpRight.isVisible()) {
            int n2 = V2CMain.nPopupTreePaneRWidth;
            this.jpRight.setBounds(this.getWidth() - n2, 0, n2, n);
        }
    }

    public Dimension preferredLayoutSize() {
        return this.jcContent != null ? this.jcContent.getPreferredSize() : new Dimension(100, 100);
    }

    public Dimension minimumLayoutSize() {
        return this.jcContent != null ? this.jcContent.getMinimumSize() : new Dimension(100, 100);
    }

    private class DnDListener
    implements DropTargetListener {
        final boolean bLeft;

        DnDListener(boolean bl) {
            this.bLeft = bl;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.rejectDrag();
            V2CCenterPanel.this.startPopupTimer(this.bLeft);
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.rejectDrag();
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.rejectDrag();
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            V2CCenterPanel.this.stopPopupTimer();
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            dropTargetDropEvent.rejectDrop();
        }
    }

    private class MouseExitListener
    extends V2CMouseExitListener {
        final boolean bLeft;

        MouseExitListener(boolean bl) {
            this.bLeft = bl;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiersEx() != 0 || !V2CMain.v2cMain.isFocused() && !V2CMain.v2cMain.isActive()) {
                return;
            }
            if (V2CCenterPanel.this.jcContent != null) {
                Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), V2CCenterPanel.this.jcContent);
                Component component = SwingUtilities.getDeepestComponentAt(V2CCenterPanel.this.jcContent, point.x, point.y);
                if (component != null && SwingUtilities.getAncestorOfClass(class$org$monazilla$v2c$V2CWritePanel == null ? (class$org$monazilla$v2c$V2CWritePanel = V2CCenterPanel.class$("org.monazilla.v2c.V2CWritePanel")) : class$org$monazilla$v2c$V2CWritePanel, component) != null) {
                    return;
                }
            }
            V2CCenterPanel.this.startPopupTimer(this.bLeft);
        }

        void doExitAction(MouseEvent mouseEvent) {
            V2CCenterPanel.this.stopPopupTimer();
        }
    }
}

