/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBeIDSP;
import org.monazilla.v2c.V2CGenHighlightStyle;
import org.monazilla.v2c.V2CHighlightSelectionPanel;
import org.monazilla.v2c.V2CHighlightStyle;
import org.monazilla.v2c.V2CKeywordUtil;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CNGItem;
import org.monazilla.v2c.V2CNGWordMatrix;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadPanel;

public class V2CBeIDItem
implements V2CNGItem {
    private static final String sSaveKey = "Be.ID:";
    static final HashMap hmBeIDs = new HashMap();
    static boolean bRestored;
    final int nID;
    boolean bNG;
    boolean bNGThread;
    int iWeight;
    int nMaxRecDepth;
    boolean bTransparent;
    String sLabel;
    V2CGenHighlightStyle vGenHighlightStyle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ArrayList getAllIDs() {
        V2CBeIDItem[] v2CBeIDItemArray;
        int n;
        ArrayList<V2CBeIDItem> arrayList = new ArrayList<V2CBeIDItem>();
        HashMap hashMap = hmBeIDs;
        synchronized (hashMap) {
            if (!bRestored) {
                bRestored = true;
                V2CBeIDItem.restoreState();
            }
            if ((n = hmBeIDs.size()) == 0) {
                return arrayList;
            }
            v2CBeIDItemArray = new V2CBeIDItem[n];
            Iterator iterator = hmBeIDs.values().iterator();
            for (int i = 0; i < n; ++i) {
                v2CBeIDItemArray[i] = (V2CBeIDItem)iterator.next();
            }
        }
        Arrays.sort(v2CBeIDItemArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((V2CBeIDItem)object).nID - ((V2CBeIDItem)object2).nID;
            }
        });
        for (int i = 0; i < n; ++i) {
            arrayList.add(v2CBeIDItemArray[i]);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static V2CBeIDItem get(Integer n) {
        HashMap hashMap = hmBeIDs;
        synchronized (hashMap) {
            if (!bRestored) {
                bRestored = true;
                V2CBeIDItem.restoreState();
            }
            return (V2CBeIDItem)hmBeIDs.get(n);
        }
    }

    private static void restoreState() {
        V2CPackedPropValue[] v2CPackedPropValueArray = V2CApp.getUserProperty().getPackedValueArray(sSaveKey);
        if (v2CPackedPropValueArray == null) {
            return;
        }
        int n = v2CPackedPropValueArray.length;
        for (int i = 0; i < n; ++i) {
            V2CPackedPropValue v2CPackedPropValue = v2CPackedPropValueArray[i];
            int n2 = v2CPackedPropValue.getInt('I');
            String string = v2CPackedPropValue.getString('L');
            boolean bl = v2CPackedPropValue.getBoolean('H');
            boolean bl2 = v2CPackedPropValue.getBoolean('t');
            int n3 = v2CPackedPropValue.getIntInRange('w', -9, 9);
            int n4 = v2CPackedPropValue.getIntInRangeIfExists('D', -1, 0, 100);
            boolean bl3 = v2CPackedPropValue.getBoolean('T');
            V2CGenHighlightStyle v2CGenHighlightStyle = v2CPackedPropValue.getBoolean('h') ? new V2CGenHighlightStyle(v2CPackedPropValue) : null;
            V2CBeIDItem.add(n2, string, bl, bl2, bl3, n3, n4, v2CGenHighlightStyle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveState() {
        ArrayList<V2CPackedPropValue> arrayList;
        HashMap hashMap = hmBeIDs;
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            if (hashMap.size() == 0) {
                v2CProperty.remove(sSaveKey);
                return;
            }
            arrayList = new ArrayList<V2CPackedPropValue>();
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                V2CPackedPropValue v2CPackedPropValue = ((V2CBeIDItem)iterator.next()).getSaveValue();
                if (v2CPackedPropValue == null) continue;
                arrayList.add(v2CPackedPropValue);
            }
        }
        int n = arrayList.size();
        if (n > 0) {
            v2CProperty.putPackedValueArray(sSaveKey, arrayList.toArray(new V2CPackedPropValue[n]));
        } else {
            v2CProperty.remove(sSaveKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(int n, String string, boolean bl, boolean bl2, boolean bl3, int n2, int n3, V2CGenHighlightStyle v2CGenHighlightStyle) {
        if (n <= 0 || string == null || string.length() == 0) {
            return;
        }
        HashMap hashMap = hmBeIDs;
        synchronized (hashMap) {
            hmBeIDs.put(new Integer(n), new V2CBeIDItem(n, string, bl, bl2, bl3, n2, n3, v2CGenHighlightStyle));
        }
    }

    static void add(Integer n, boolean bl) {
        String string;
        boolean bl2;
        boolean bl3;
        if (n == null) {
            return;
        }
        int n2 = n;
        if (n2 <= 0) {
            return;
        }
        V2CBeIDItem v2CBeIDItem = V2CBeIDItem.get(n);
        boolean bl4 = bl3 = v2CBeIDItem != null;
        if (bl3) {
            bl2 = v2CBeIDItem.bNG;
            if (bl && bl2) {
                V2CMain.setErrorMessage("\u65e2\u306b\u975e\u8868\u793a\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                return;
            }
            string = v2CBeIDItem.getLabel();
        } else {
            bl2 = false;
            string = String.valueOf(n2);
        }
        V2CBeIDSP v2CBeIDSP = new V2CBeIDSP(n2, string, bl3 && !bl2 && !bl);
        if (!v2CBeIDSP.showDialog()) {
            return;
        }
        String string2 = v2CBeIDSP.getLabel();
        if (string2 == null) {
            if (bl2) {
                return;
            }
            V2CBeIDItem.remove(n);
            V2CThreadPanel.styleChanged();
            return;
        }
        if (string2.length() == 0) {
            V2CSwingUtil.showErrorMessage("\u30e9\u30d9\u30eb\u304c\u7a7a\u3067\u3059\u3002");
            return;
        }
        if (bl3) {
            v2CBeIDItem.sLabel = string2;
            if (bl) {
                v2CBeIDItem.bNG = true;
            }
        } else {
            V2CBeIDItem.add(n2, string2, bl, false, false, 0, -1, null);
        }
        V2CBeIDItem.saveState();
        if (bl) {
            V2CThreadPanel.applyNGKWordToPanels();
        } else {
            V2CThreadPanel.styleChanged();
        }
    }

    static void remove(V2CBeIDItem v2CBeIDItem) {
        if (v2CBeIDItem != null) {
            V2CBeIDItem.remove(new Integer(v2CBeIDItem.nID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(Integer n) {
        HashMap hashMap = hmBeIDs;
        synchronized (hashMap) {
            hmBeIDs.remove(n);
        }
        V2CBeIDItem.saveState();
    }

    public V2CBeIDItem(int n, String string, boolean bl, boolean bl2, boolean bl3, int n2, int n3, V2CGenHighlightStyle v2CGenHighlightStyle) {
        this.nID = n;
        this.sLabel = string;
        this.bNG = bl;
        this.bNGThread = bl2;
        this.bTransparent = bl && bl3;
        this.iWeight = n2;
        this.nMaxRecDepth = n3;
        if (n3 > 0) {
            V2CNGWordMatrix.setRecursiveUsed();
        }
        this.vGenHighlightStyle = v2CGenHighlightStyle;
    }

    V2CPackedPropValue getSaveValue() {
        int n = this.nID;
        String string = this.sLabel;
        if (n <= 0 || string == null || string.length() == 0 || string.indexOf(9) >= 0) {
            return null;
        }
        V2CPackedPropValue v2CPackedPropValue = this.vGenHighlightStyle != null ? this.vGenHighlightStyle.getSaveValue() : new V2CPackedPropValue();
        v2CPackedPropValue.setInt('I', n);
        v2CPackedPropValue.setString('L', string);
        v2CPackedPropValue.setBoolean('H', this.bNG);
        v2CPackedPropValue.setBoolean('t', this.bNGThread);
        v2CPackedPropValue.setBoolean('T', this.bTransparent);
        if (this.iWeight != 0) {
            v2CPackedPropValue.setInt('w', this.iWeight);
        }
        if (this.nMaxRecDepth >= 0) {
            v2CPackedPropValue.setInt('D', this.nMaxRecDepth);
        }
        return v2CPackedPropValue;
    }

    int getID() {
        return this.nID;
    }

    String getLabel() {
        return this.sLabel;
    }

    boolean isNG() {
        return this.bNG;
    }

    boolean isNGThread() {
        return this.bNGThread;
    }

    boolean setLabel(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if ((string = V2CMiscUtil.replaceTab2SP(string)).equals(this.sLabel)) {
            return false;
        }
        this.sLabel = string;
        V2CBeIDItem.saveState();
        return true;
    }

    void setNG(boolean bl) {
        if (bl == this.bNG) {
            return;
        }
        this.bNG = bl;
        if (!bl) {
            this.bTransparent = false;
        }
        V2CBeIDItem.saveState();
    }

    void setNGThread(boolean bl) {
        if (bl == this.bNGThread) {
            return;
        }
        this.bNGThread = bl;
        V2CBeIDItem.saveState();
    }

    void setWeight(String string) {
        int n = V2CKeywordUtil.toWeight(string);
        if (this.iWeight == n) {
            return;
        }
        this.iWeight = n;
        V2CBeIDItem.saveState();
    }

    void setTransparent(boolean bl) {
        if (bl == this.bTransparent) {
            return;
        }
        this.bTransparent = bl;
        V2CBeIDItem.saveState();
    }

    public String getReasonString() {
        return "Be\uff1a" + this.sLabel;
    }

    public int getWeight() {
        return this.iWeight;
    }

    public int getMaxRecDepth() {
        return this.nMaxRecDepth;
    }

    void setMaxRecDepth(int n) {
        if (this.nMaxRecDepth == n) {
            return;
        }
        this.nMaxRecDepth = n;
        V2CBeIDItem.saveState();
        if (n > 0) {
            V2CNGWordMatrix.setRecursiveUsed();
        }
    }

    public boolean isTransparent() {
        return this.bTransparent;
    }

    V2CHighlightStyle getHighlightStyle() {
        return this.vGenHighlightStyle != null ? this.vGenHighlightStyle.getStyle() : null;
    }

    void setHighlightStyle(V2CHighlightSelectionPanel v2CHighlightSelectionPanel) {
        this.vGenHighlightStyle = v2CHighlightSelectionPanel != null ? V2CGenHighlightStyle.getGenHighlightStyle(v2CHighlightSelectionPanel, true) : null;
        V2CBeIDItem.saveState();
        V2CThreadPanel.repaintActivePanels(true);
    }
}

