/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import javax.swing.JPanel;
import org.monazilla.v2c.V2CImageCache;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadPanel;

public class V2CBackgroundImageSetting
extends JPanel {
    static final int FIT_ORIGINAL = 0;
    static final int FIT_WIDTH = 1;
    static final int FIT_HEIGHT = 2;
    static final String[] slAnchors = new String[9];
    static final String[] slScales = new String[3];
    static final int[] nlLeftRight = new int[]{-1, 0, 1, 1, 1, 0, -1, -1, 0};
    static final int[] nlTopBottom = new int[]{-1, -1, -1, 0, 1, 1, 1, 0, 0};
    static final String sKeyPrefix = "ThreadView.BackgroundImage";
    static final String sBGImageKey = "ThreadView.BackgroundImage";
    static final String sBGIIntensityScaleKey = "ThreadView.BackgroundImageIntensityScale";
    static final String sBGIIntensityOffsetKey = "ThreadView.BackgroundImageIntensityOffset";
    static final String sBGIMirrorKey = "ThreadView.BackgroundImageMirror";
    static final String sBGITilingKey = "ThreadView.BackgroundImageTiling";
    static final String sBGIScaleKey = "ThreadView.BackgroundImageScale";
    static final String sBGIAnchorKey = "ThreadView.BackgroundImageAnchor";
    String sFileName;
    V2CThreadPanel vThreadPanel;
    V2CImageCache vicBackground;
    int nAnchor;
    int nSizeScale;
    boolean bTiling;
    boolean bMirror;
    float fIntensityScale;
    float fIntensityOffset;

    public V2CBackgroundImageSetting(V2CProperty v2CProperty) {
        this(v2CProperty, null);
    }

    public V2CBackgroundImageSetting(V2CProperty v2CProperty, V2CThreadPanel v2CThreadPanel) {
        if (v2CProperty == null) {
            return;
        }
        this.vThreadPanel = v2CThreadPanel;
        this.createImageCache(v2CProperty);
    }

    void createImageCache(V2CProperty v2CProperty) {
        String string;
        Object object;
        String string2 = v2CProperty.get("ThreadView.BackgroundImage");
        this.sFileName = string2 != null && string2.length() > 0 ? V2CLocalFileHandler.parseV2CRelativePath(string2) : null;
        this.fIntensityScale = v2CProperty.getFloat(sBGIIntensityScaleKey, 0.5f);
        this.fIntensityOffset = v2CProperty.getFloat(sBGIIntensityOffsetKey, 0.5f);
        this.bMirror = v2CProperty.getBoolean(sBGIMirrorKey);
        RescaleOp rescaleOp = null;
        if (this.fIntensityScale != 1.0f || this.fIntensityOffset != 0.0f) {
            object = new float[]{this.fIntensityScale, this.fIntensityScale, this.fIntensityScale};
            float f = this.fIntensityOffset * 256.0f;
            float[] fArray = new float[]{f, f, f};
            rescaleOp = new RescaleOp((float[])object, fArray, null);
        }
        this.vicBackground = this.vThreadPanel != null && this.sFileName != null && this.sFileName.length() > 0 ? V2CImageCache.getFromLocalFile(this.sFileName, rescaleOp, this.bMirror, this.vThreadPanel) : null;
        this.bTiling = v2CProperty.getBoolean(sBGITilingKey);
        object = v2CProperty.get(sBGIScaleKey);
        if (object != null && ((String)object).length() > 0) {
            for (int i = 0; i < slScales.length; ++i) {
                if (!slScales[i].equals(object)) continue;
                this.nSizeScale = i;
                break;
            }
        }
        if ((string = v2CProperty.get(sBGIAnchorKey)) != null && string.length() > 0) {
            for (int i = 0; i < slAnchors.length; ++i) {
                if (!slAnchors[i].equals(string)) continue;
                this.nAnchor = i;
                break;
            }
        }
    }

    void imageChanged() {
        V2CThreadItem v2CThreadItem = this.vThreadPanel.getThreadItem();
        if (v2CThreadItem == null) {
            return;
        }
        if (this.vicBackground != null) {
            this.vicBackground.removeClient(this.vThreadPanel);
            this.vicBackground = null;
        }
        this.createImageCache(v2CThreadItem.getProperty());
    }

    void drawBackground(Graphics2D graphics2D, V2CThreadPanel v2CThreadPanel) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.vicBackground == null) {
            return;
        }
        BufferedImage bufferedImage = this.vicBackground.getImage();
        if (bufferedImage == null) {
            return;
        }
        int n6 = nlLeftRight[this.nAnchor];
        int n7 = nlTopBottom[this.nAnchor];
        boolean bl = (n6 == 1 || n7 == 1) && !this.bTiling;
        Rectangle rectangle = v2CThreadPanel.getDrawingRect();
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = bufferedImage.getWidth();
        int n13 = bufferedImage.getHeight();
        if (this.nSizeScale == 1) {
            n13 = (int)((float)n13 * (float)n8 / (float)n12);
            n12 = n8;
        } else if (this.nSizeScale == 2) {
            n12 = (int)((float)n12 * (float)n9 / (float)n13);
            n13 = n9;
        }
        int n14 = n10;
        int n15 = n11;
        switch (n6) {
            case 0: {
                n14 += (n8 - n12) / 2;
                break;
            }
            case 1: {
                n14 += n8 - n12;
            }
        }
        switch (n7) {
            case 0: {
                n15 += (n9 - n13) / 2;
                break;
            }
            case 1: {
                n15 += n9 - n13;
            }
        }
        if (this.bTiling) {
            n5 = n14 > n10 ? -(n14 - n10 - 1) / n12 - 1 : 0;
            n4 = n10 + n8 - (n14 + n12);
            n3 = n4 > 0 ? (n4 - 1) / n12 + 2 : 1;
            n2 = n15 > n11 ? -(n15 - n11 - 1) / n13 - 1 : 0;
            n4 = n11 + n9 - (n15 + n13);
            n = n4 > 0 ? (n4 - 1) / n13 + 2 : 1;
        } else {
            n2 = 0;
            n5 = 0;
            n = 1;
            n3 = 1;
        }
        n4 = this.nSizeScale == 0 ? 1 : 0;
        for (int i = n5; i < n3; ++i) {
            int n16 = n14 + i * n12;
            for (int j = n2; j < n; ++j) {
                int n17 = n15 + j * n13;
                if (n4 != 0) {
                    graphics2D.drawImage((Image)bufferedImage, n16, n17, null);
                    continue;
                }
                graphics2D.drawImage(bufferedImage, n16, n17, n12, n13, null);
            }
        }
    }

    boolean isImageSet() {
        return this.vicBackground != null;
    }

    static {
        V2CBackgroundImageSetting.slScales[0] = "\u539f\u5bf8";
        V2CBackgroundImageSetting.slScales[1] = "\u5e45\u306b\u5408\u305b\u308b";
        V2CBackgroundImageSetting.slScales[2] = "\u9ad8\u3055\u306b\u5408\u305b\u308b";
        String string = "\u5de6";
        String string2 = "\u53f3";
        String string3 = "\u4e0a";
        String string4 = "\u4e0b";
        V2CBackgroundImageSetting.slAnchors[0] = string + string3;
        V2CBackgroundImageSetting.slAnchors[1] = string3;
        V2CBackgroundImageSetting.slAnchors[2] = string2 + string3;
        V2CBackgroundImageSetting.slAnchors[3] = string2;
        V2CBackgroundImageSetting.slAnchors[4] = string2 + string4;
        V2CBackgroundImageSetting.slAnchors[5] = string4;
        V2CBackgroundImageSetting.slAnchors[6] = string + string4;
        V2CBackgroundImageSetting.slAnchors[7] = string;
        V2CBackgroundImageSetting.slAnchors[8] = "\u4e2d\u5fc3";
    }
}

