/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.monazilla.v2c.V2CColorSelectButton;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CAlphaColorSelector
extends JPanel {
    V2CColorSelectButton csbColor;
    JFormattedTextField jftfAlpha;

    public V2CAlphaColorSelector(Color color) {
        super(new GridBagLayout());
        V2CColorSelectButton v2CColorSelectButton;
        if (color == null) {
            color = Color.WHITE;
        }
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        this.csbColor = v2CColorSelectButton = new V2CColorSelectButton(color, true);
        this.add((Component)v2CColorSelectButton, gridBagConstraints);
        if (V2CColorSelectButton.bHasAlpha) {
            return;
        }
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel(" \u03b1:"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setGroupingUsed(false);
        this.jftfAlpha = new JFormattedTextField(numberFormat);
        this.jftfAlpha.setValue(new Float((float)color.getAlpha() / 255.0f));
        this.jftfAlpha.setColumns(6);
        this.jftfAlpha.setHorizontalAlignment(4);
        this.add((Component)this.jftfAlpha, gridBagConstraints);
    }

    Color getColor() {
        Color color = this.csbColor.getColor();
        if (V2CColorSelectButton.bHasAlpha) {
            return color;
        }
        float f = V2CSwingUtil.getFloat(this.jftfAlpha);
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)(f * 255.0f) + 0.5));
    }
}

