/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Timer;
import org.monazilla.v2c.V2CAlarmSP;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CAlarm {
    private static final String sAlarmConfKey = "Alarm.Conf:";
    static boolean bAbsTime;
    static int nWaitHour;
    static int nWaitMin;
    static int nAbsHour;
    static int nAbsMin;
    private static Timer vLevelUpAlarm;
    private static long ltAlarmTime;

    static void saveConf() {
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        if (ltAlarmTime > 0L || bAbsTime || nWaitHour > 0 || nWaitMin > 0 || nAbsHour > 0 || nAbsMin > 0) {
            V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
            if (ltAlarmTime > 0L) {
                v2CPackedPropValue.setLong('T', ltAlarmTime);
            }
            v2CPackedPropValue.setBoolean('a', bAbsTime);
            if (nWaitHour > 0) {
                v2CPackedPropValue.setInt('H', nWaitHour);
            }
            if (nWaitMin > 0) {
                v2CPackedPropValue.setInt('M', nWaitMin);
            }
            if (nAbsHour > 0) {
                v2CPackedPropValue.setInt('h', nAbsHour);
            }
            if (nAbsMin > 0) {
                v2CPackedPropValue.setInt('m', nAbsMin);
            }
            v2CProperty.putPackedValue(sAlarmConfKey, v2CPackedPropValue);
        } else {
            v2CProperty.remove(sAlarmConfKey);
        }
    }

    static void checkAlarm() {
        long l = ltAlarmTime;
        if (l <= 0L) {
            return;
        }
        long l2 = System.currentTimeMillis() / 1000L;
        if (l2 >= l) {
            V2CAlarm.fireAlarm();
        } else {
            V2CAlarm.startAlarmTimer((int)(l - l2) * 1000);
        }
    }

    static void config() {
        Timer timer = vLevelUpAlarm;
        if (timer != null) {
            if (!V2CSwingUtil.showOKCancelWarningDialog("\u30a2\u30e9\u30fc\u30e0\u3092\u505c\u6b62\u3057\u307e\u3059\n\uff08\u4e88\u5b9a\u6642\u523b\uff1a " + new SimpleDateFormat("HH:mm").format(new Date(ltAlarmTime * 1000L)) + "\uff09", "V2C \u30a2\u30e9\u30fc\u30e0")) {
                return;
            }
            timer.stop();
            vLevelUpAlarm = null;
            ltAlarmTime = 0L;
        } else {
            int n;
            V2CAlarmSP v2CAlarmSP = new V2CAlarmSP();
            if (!v2CAlarmSP.showDialog()) {
                return;
            }
            long l = System.currentTimeMillis() / 1000L;
            if (bAbsTime) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(11, nAbsHour);
                gregorianCalendar.set(12, nAbsMin);
                gregorianCalendar.set(13, 0);
                long l2 = gregorianCalendar.getTime().getTime() / 1000L;
                if (l2 <= l) {
                    l2 += 86400L;
                }
                n = (int)(l2 - l);
            } else {
                n = (nWaitHour * 60 + nWaitMin) * 60;
            }
            if (n <= 0) {
                return;
            }
            ltAlarmTime = (long)n + l;
            V2CAlarm.startAlarmTimer(n * 1000);
        }
        V2CAlarm.saveConf();
    }

    private static void startAlarmTimer(int n) {
        Timer timer;
        vLevelUpAlarm = timer = new Timer(n, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (V2CApp.isQuitting()) {
                    return;
                }
                V2CAlarm.fireAlarm();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    static void fireAlarm() {
        vLevelUpAlarm = null;
        ltAlarmTime = 0L;
        V2CAlarm.saveConf();
        String string = "V2C \u30a2\u30e9\u30fc\u30e0";
        String string2 = "\u30a2\u30e9\u30fc\u30e0\u6642\u9593\u3092\u904e\u304e\u307e\u3057\u305f";
        Toolkit.getDefaultToolkit().beep();
        if (V2CMain.v2cMain.isInTray()) {
            V2CMain.displayTrayMessage(string, string2);
        }
        V2CSwingUtil.showInformationMessage(string2, string);
    }

    static {
        V2CPackedPropValue v2CPackedPropValue = V2CApp.getUserProperty().getPackedValue(sAlarmConfKey);
        if (v2CPackedPropValue != null) {
            ltAlarmTime = v2CPackedPropValue.getLong('T');
            bAbsTime = v2CPackedPropValue.getBoolean('a');
            nWaitHour = v2CPackedPropValue.getIntInRange('H', 0, 23);
            nWaitMin = v2CPackedPropValue.getIntInRange('M', 0, 59);
            nAbsHour = v2CPackedPropValue.getIntInRange('h', 0, 23);
            nAbsMin = v2CPackedPropValue.getIntInRange('m', 0, 59);
        }
    }
}

