/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.monazilla.v2c.V2CAbstractAction;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CExtCommandAction;
import org.monazilla.v2c.V2CGestureMapConstants;
import org.monazilla.v2c.V2CInputMapConstants;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CThreadList;

public class V2CActionMap
extends ActionMap
implements V2CInputMapConstants,
V2CGestureMapConstants {
    static final HashMap hmActions = new HashMap(300);
    static final HashMap hmActionsToLoad = new HashMap(300);

    static void putAction(String string, V2CAbstractAction v2CAbstractAction) {
        hmActions.put(string, v2CAbstractAction);
    }

    static void putActionsToLoad(String string, int n, boolean bl, boolean bl2) {
        hmActionsToLoad.put(string, new ActionParms(string, n, bl, bl2));
    }

    static void putTLSortActions() {
        String[][] stringArray = V2CThreadList.slColumnLabel;
        char[] cArray = new char[8];
        "TLSort00".getChars(0, 8, cArray, 0);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = stringArray[i];
            if (i >= 10) {
                cArray[6] = (char)(i / 10 + 48);
            }
            cArray[7] = (char)(i % 10 + 48);
            String string = new String(cArray);
            hmActionsToLoad.put(string, new ActionParms(string, i, stringArray2[2]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeExtCommandActions() {
        HashMap hashMap;
        HashMap hashMap2 = hashMap = hmActions;
        synchronized (hashMap2) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object v = hashMap.get(iterator.next());
                if (!(v instanceof V2CExtCommandAction)) continue;
                iterator.remove();
            }
        }
    }

    private static Action loadAction(ActionParms actionParms, boolean bl) {
        V2CAbstractAction v2CAbstractAction;
        String string = actionParms.sName;
        if (bl) {
            hmActionsToLoad.remove(string);
        }
        if ((v2CAbstractAction = actionParms.createAction()) == null) {
            return null;
        }
        hmActions.put(string, v2CAbstractAction);
        return v2CAbstractAction;
    }

    private static void loadAllMapActions(boolean bl, boolean bl2) {
        HashMap hashMap = hmActionsToLoad;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            ActionParms actionParms = (ActionParms)hashMap.get(iterator.next());
            if (!bl && !(bl2 ? actionParms.bInputMap : actionParms.bGestureMap)) continue;
            V2CActionMap.loadAction(actionParms, false);
            iterator.remove();
        }
    }

    private static V2CAbstractAction[] createActionArray(boolean bl) {
        V2CActionMap.loadAllMapActions(false, bl);
        Object[] objectArray = V2CActionMap.getKeys();
        int n = objectArray.length;
        Arrays.sort(objectArray);
        V2CAbstractAction[] v2CAbstractActionArray = new V2CAbstractAction[n];
        for (int i = 0; i < n; ++i) {
            v2CAbstractActionArray[i] = (V2CAbstractAction)V2CActionMap.getAction(objectArray[i]);
        }
        return v2CAbstractActionArray;
    }

    static V2CAbstractAction[][] createInputActions() {
        ActionComparator actionComparator = new ActionComparator();
        V2CAbstractAction[] v2CAbstractActionArray = V2CActionMap.createActionArray(true);
        int n = v2CAbstractActionArray.length;
        int n2 = slInputMapName.length;
        V2CAbstractAction[][] v2CAbstractActionArray2 = new V2CAbstractAction[n2][];
        V2CAbstractAction[] v2CAbstractActionArray3 = new V2CAbstractAction[n];
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            int n4 = 1 << i;
            for (int j = 0; j < n; ++j) {
                V2CAbstractAction v2CAbstractAction = v2CAbstractActionArray[j];
                if ((v2CAbstractAction.nInputMapMask & n4) == 0) continue;
                v2CAbstractActionArray3[n3++] = v2CAbstractActionArray[j];
            }
            V2CAbstractAction[] v2CAbstractActionArray4 = new V2CAbstractAction[n3];
            if (n3 > 0) {
                System.arraycopy(v2CAbstractActionArray3, 0, v2CAbstractActionArray4, 0, n3);
            }
            Arrays.sort(v2CAbstractActionArray4, actionComparator);
            v2CAbstractActionArray2[i] = v2CAbstractActionArray4;
        }
        return v2CAbstractActionArray2;
    }

    static V2CAbstractAction[][] createGestureActions() {
        ActionComparator actionComparator = new ActionComparator();
        V2CAbstractAction[] v2CAbstractActionArray = V2CActionMap.createActionArray(false);
        int n = v2CAbstractActionArray.length;
        int n2 = slGestureMapName.length;
        V2CAbstractAction[][] v2CAbstractActionArray2 = new V2CAbstractAction[n2][];
        V2CAbstractAction[] v2CAbstractActionArray3 = new V2CAbstractAction[n];
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            int n4 = 1 << i;
            for (int j = 0; j < n; ++j) {
                V2CAbstractAction v2CAbstractAction = v2CAbstractActionArray[j];
                if ((v2CAbstractAction.nGestureMapMask & n4) == 0) continue;
                v2CAbstractActionArray3[n3++] = v2CAbstractActionArray[j];
            }
            V2CAbstractAction[] v2CAbstractActionArray4 = new V2CAbstractAction[n3];
            if (n3 > 0) {
                System.arraycopy(v2CAbstractActionArray3, 0, v2CAbstractActionArray4, 0, n3);
            }
            Arrays.sort(v2CAbstractActionArray4, actionComparator);
            v2CAbstractActionArray2[i] = v2CAbstractActionArray4;
        }
        return v2CAbstractActionArray2;
    }

    public Action get(Object object) {
        Action action = V2CActionMap.getAction(object);
        if (action != null) {
            return action;
        }
        ActionMap actionMap = this.getParent();
        return actionMap != null ? actionMap.get(object) : null;
    }

    static Action getAction(Object object) {
        Action action = (Action)hmActions.get(object);
        if (action != null) {
            return action;
        }
        ActionParms actionParms = (ActionParms)hmActionsToLoad.get(object);
        return actionParms != null ? V2CActionMap.loadAction(actionParms, true) : null;
    }

    Action getLoadedAction(Object object) {
        Action action = (Action)hmActions.get(object);
        if (action != null) {
            return action;
        }
        ActionMap actionMap = this.getParent();
        return actionMap != null ? actionMap.get(object) : null;
    }

    public void remove(Object object) {
        hmActions.remove(object);
        hmActionsToLoad.remove(object);
    }

    public int size() {
        return hmActions.size() + hmActionsToLoad.size();
    }

    public Object[] allKeys() {
        ActionMap actionMap = this.getParent();
        Object[] objectArray = V2CActionMap.addActionsToLoad(actionMap != null ? actionMap.allKeys() : new Object[]{}, false);
        return V2CActionMap.addActionsToLoad(objectArray, true);
    }

    public Object[] keys() {
        return V2CActionMap.getKeys();
    }

    private static Object[] getKeys() {
        Object[] objectArray = V2CActionMap.addActionsToLoad(new Object[0], false);
        return V2CActionMap.addActionsToLoad(objectArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] addActionsToLoad(Object[] objectArray, boolean bl) {
        Object[] objectArray2;
        int n;
        HashMap hashMap = bl ? hmActionsToLoad : hmActions;
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            n = hashMap.size();
            if (n == 0) {
                return objectArray;
            }
            objectArray2 = hashMap.keySet().toArray();
        }
        n = objectArray2.length;
        int n2 = objectArray.length;
        Object[] objectArray3 = new Object[n2 + n];
        if (n2 > 0) {
            System.arraycopy(objectArray, 0, objectArray3, 0, n2);
        }
        System.arraycopy(objectArray2, 0, objectArray3, n2, n);
        return objectArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void restoreActionProperties() {
        BufferedReader bufferedReader = V2CLocalFileHandler.getConfigReader("action.txt");
        if (bufferedReader == null) {
            System.out.println("cannot read action.txt !");
            V2CApp.immediateExit(1);
            return;
        }
        try {
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.length() == 0 || string.charAt(0) == '#') continue;
                    String[] stringArray = V2CMiscUtil.split(string);
                    String string2 = stringArray[0];
                    V2CAbstractAction v2CAbstractAction = (V2CAbstractAction)hmActions.get(string2);
                    if (v2CAbstractAction != null) {
                        v2CAbstractAction.setActionProp(stringArray);
                        continue;
                    }
                    ActionParms actionParms = (ActionParms)hmActionsToLoad.get(string2);
                    if (actionParms != null) {
                        actionParms.setProps(stringArray);
                        continue;
                    }
                    System.out.println("unknown action: " + string2);
                }
                Object var8_7 = null;
            }
            catch (IOException iOException) {
                System.out.println("IOException while reading action.txt !");
                iOException.printStackTrace();
                V2CApp.immediateExit(1);
                Object var8_8 = null;
                V2CLocalFileHandler.closeReader(bufferedReader);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            V2CLocalFileHandler.closeReader(bufferedReader);
            throw throwable;
        }
        V2CLocalFileHandler.closeReader(bufferedReader);
    }

    private static class ActionComparator
    implements Comparator {
        private ActionComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((V2CAbstractAction)object).getSeqNo() - ((V2CAbstractAction)object2).getSeqNo();
        }
    }

    private static class ActionParms {
        final String sName;
        final int nSeqNo;
        final boolean bInputMap;
        final boolean bGestureMap;
        final int iTLSort;
        String[] slProps;

        ActionParms(String string, int n, String string2) {
            this.sName = string;
            this.nSeqNo = V2CAbstractAction.createSeqNo();
            this.bInputMap = true;
            this.bGestureMap = true;
            this.iTLSort = n;
            this.slProps = new String[]{null, null, null, null, string2 + " \u3067\u30bd\u30fc\u30c8"};
        }

        ActionParms(String string, int n, boolean bl, boolean bl2) {
            this.sName = string;
            this.nSeqNo = n;
            this.bInputMap = bl;
            this.bGestureMap = bl2;
            this.iTLSort = -1;
        }

        void setProps(String[] stringArray) {
            this.slProps = stringArray;
        }

        V2CAbstractAction createAction() {
            Object object;
            V2CAbstractAction v2CAbstractAction;
            if (this.iTLSort >= 0) {
                v2CAbstractAction = V2CAction.createTLSortAction(this.iTLSort);
            } else {
                try {
                    object = Class.forName("org.monazilla.v2c.V2CAction$" + this.sName);
                    Constructor constructor = ((Class)object).getConstructor(null);
                    v2CAbstractAction = (V2CAbstractAction)constructor.newInstance(null);
                }
                catch (Exception exception) {
                    System.out.println(exception.getClass() + ": " + exception.getMessage());
                    return null;
                }
            }
            v2CAbstractAction.setSeqNo(this.nSeqNo);
            object = this.slProps;
            if (object != null) {
                v2CAbstractAction.setActionProp((String[])object);
            }
            v2CAbstractAction.setName(this.sName);
            return v2CAbstractAction;
        }
    }
}

