/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.im.InputContext;
import java.io.File;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.monazilla.migemo.Migemo;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CDialogBoardList;
import org.monazilla.v2c.V2CEditOperation;
import org.monazilla.v2c.V2CInputMap;
import org.monazilla.v2c.V2CKeyPopupMenu;
import org.monazilla.v2c.V2CLauncher;
import org.monazilla.v2c.V2CListTable;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMac5MiniSearch;
import org.monazilla.v2c.V2CMacMiniSearch;
import org.monazilla.v2c.V2CMacQuaquaSupport;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiniSearch;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSearchHistoryItem;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CToolBar;
import org.monazilla.v2c.V2CToolBarComponentSettingPanel;
import org.monazilla.v2c.V2CTree;
import org.monazilla.v2c.V2CWebSearchEntry;
import org.monazilla.v2c.V2CWebSearchItem;
import org.monazilla.v2c.V2CWebSearchList;

public abstract class V2CAbstractMiniSearch
extends JPanel
implements DocumentListener,
FocusListener,
InputMethodListener,
MouseWheelListener,
V2CEditOperation,
V2CKeyPopupMenu {
    static final int DEFMINWIDTH = 110;
    static final int TREE = 0;
    static final int TABLE = 1;
    static final int DISPLAY = 2;
    static final int DIALOGTABLE = 3;
    static final int TABG_NORMAL = 0;
    static final int TABG_ISEARCH = 1;
    static final int TABG_MIGEMO = 2;
    static final int TABG_MIGEMODICT = 3;
    static final V2CAbstractMiniSearch[] vlMiniSearch = new V2CAbstractMiniSearch[3];
    static final String[] slPopupMenuName = new String[]{"BoardTreeMiniSearch", "ThreadListMiniSearch", "ThreadViewMiniSearch", "DialogTLMiniSearch"};
    private static boolean bMigemoDictLoaded;
    private static boolean bLoadMigemoDictTried;
    int iType;
    final String sID;
    final String sWidthKey;
    final String sCondKey;
    int nWidth;
    JTextField jtfSearchWords;
    PopupListener mlPopupListener;
    boolean bRegExp;
    boolean bCaseSensitive;
    boolean bAnd;
    boolean bOr;
    boolean bMessageBodyOnly;
    boolean bMigemo;
    boolean bRealTime;
    boolean bIgnoreTextChange;
    int nCommittedCharacterCount;
    int nCombinedCharacterCount;
    boolean bRegExpError;
    boolean bInISearch;
    boolean bInMigemo;
    V2CThreadPanel tpISearchThreadPanel;
    Color cDefaultBG;
    String sLastText;
    V2CDialogBoardList vDialogBoardList;

    static V2CAbstractMiniSearch getDisplayPaneMiniSearch() {
        return V2CAbstractMiniSearch.getInstance(2, false);
    }

    private static V2CAbstractMiniSearch createInstance(int n) {
        if (V2CApp.isMacintosh()) {
            if (V2CApp.getOSXVersion() >= 5 && !V2CMacQuaquaSupport.isQuaquaInstalled()) {
                return new V2CMac5MiniSearch(n);
            }
            return new V2CMacMiniSearch(n);
        }
        return new V2CMiniSearch(n);
    }

    static V2CAbstractMiniSearch getInstance(int n, boolean bl) {
        V2CAbstractMiniSearch v2CAbstractMiniSearch = vlMiniSearch[n];
        if (bl && v2CAbstractMiniSearch == null) {
            Object var3_3 = null;
            if (n < 0 || n > 2) {
                return null;
            }
            V2CAbstractMiniSearch.vlMiniSearch[n] = v2CAbstractMiniSearch = V2CAbstractMiniSearch.createInstance(n);
        }
        return v2CAbstractMiniSearch;
    }

    static V2CAbstractMiniSearch createInstanceForDialog(V2CDialogBoardList v2CDialogBoardList) {
        V2CAbstractMiniSearch v2CAbstractMiniSearch = V2CAbstractMiniSearch.createInstance(3);
        v2CAbstractMiniSearch.vDialogBoardList = v2CDialogBoardList;
        return v2CAbstractMiniSearch;
    }

    static void saveAllStates() {
        for (int i = 0; i < vlMiniSearch.length; ++i) {
            V2CAbstractMiniSearch v2CAbstractMiniSearch = vlMiniSearch[i];
            if (v2CAbstractMiniSearch == null) continue;
            v2CAbstractMiniSearch.saveState();
        }
        V2CSearchHistoryItem.saveHistory();
    }

    public V2CAbstractMiniSearch(int n, LayoutManager layoutManager) {
        super(layoutManager);
        String string;
        this.iType = n;
        this.sID = string = slPopupMenuName[n];
        this.sWidthKey = string + ".Width";
        this.sCondKey = string + ".Cond";
        JTextField jTextField = V2CSwingUtil.createTextField();
        this.cDefaultBG = jTextField.getBackground();
        this.jtfSearchWords = jTextField;
        jTextField.setDragEnabled(true);
        this.mlPopupListener = new PopupListener(string, this);
        jTextField.addMouseListener(this.mlPopupListener);
        jTextField.addInputMethodListener(this);
        jTextField.getDocument().addDocumentListener(this);
        jTextField.addFocusListener(this);
        jTextField.addMouseWheelListener(this);
        V2CInputMap.interceptNormalKeyForTextComponent(this);
        V2CInputMap.setKeyBind(this, 1, V2CMiscUtil.isEqual(string, slPopupMenuName[3]) ? slPopupMenuName[1] : string);
        this.restoreState(string);
        if (this.bMigemo) {
            jTextField.enableInputMethods(false);
        }
    }

    void restoreState(String string) {
        V2CPackedPropValue v2CPackedPropValue = V2CMain.getUserProperty().getPackedValue(this.sCondKey);
        if (v2CPackedPropValue != null) {
            boolean bl = v2CPackedPropValue.getBoolean('J');
            if (bl) {
                this.bMigemo = true;
            } else {
                this.bAnd = v2CPackedPropValue.getBoolean('A');
                this.bCaseSensitive = v2CPackedPropValue.getBoolean('C');
                this.bOr = !this.bAnd && v2CPackedPropValue.getBoolean('O');
                this.bRegExp = v2CPackedPropValue.getBoolean('R');
            }
            this.bMessageBodyOnly = v2CPackedPropValue.getBoolean('M');
            this.bRealTime = v2CPackedPropValue.getBoolean('T');
        }
    }

    void saveState() {
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
        if (this.bMigemo) {
            v2CPackedPropValue.setBoolean('J', this.bMigemo);
        } else {
            v2CPackedPropValue.setBoolean('A', this.bAnd);
            v2CPackedPropValue.setBoolean('C', this.bCaseSensitive);
            v2CPackedPropValue.setBoolean('O', this.bOr);
            v2CPackedPropValue.setBoolean('R', this.bRegExp);
        }
        v2CPackedPropValue.setBoolean('M', this.bMessageBodyOnly);
        v2CPackedPropValue.setBoolean('T', this.bRealTime);
        V2CMain.getUserProperty().putPackedValue(this.sCondKey, v2CPackedPropValue);
    }

    public void cut(String string) {
        this.jtfSearchWords.cut();
    }

    public void copy(String string) {
        this.jtfSearchWords.copy();
    }

    public void paste(String string) {
        this.jtfSearchWords.paste();
    }

    public void clear(String string) {
        Document document = this.jtfSearchWords.getDocument();
        try {
            document.remove(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void selectAll(String string) {
        this.jtfSearchWords.selectAll();
    }

    void loadMigemoDictionary() {
        boolean bl;
        if (bMigemoDictLoaded || bLoadMigemoDictTried) {
            return;
        }
        bLoadMigemoDictTried = true;
        String string = V2CApp.isWinType() ? "lib\\migemo\\migemo-dict" : "lib/migemo/migemo-dict";
        File file = null;
        if (V2CLauncher.startedByLauncher() && !V2CApp.isMacintosh() && !(file = new File(V2CLauncher.getApplicationDir(), string)).exists()) {
            file = null;
        }
        if (file == null) {
            file = new File(V2CLocalFileHandler.getV2CDir(), string);
        }
        boolean bl2 = bl = file.isFile() && file.canRead();
        if (!bl) {
            if (V2CApp.isUNIX()) {
                file = new File("/usr/share/migemo/migemo-dict");
                boolean bl3 = bl = file.isFile() && file.canRead();
            }
            if (!bl) {
                V2CMain.setErrorMessage("Migemo\u7528\u306e\u8f9e\u66f8\uff08migemo-dict\uff09\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
                return;
            }
        }
        bMigemoDictLoaded = true;
        this.setISearchColor(3);
        JTextField jTextField = this.jtfSearchWords;
        jTextField.paintImmediately(0, 0, jTextField.getWidth(), jTextField.getHeight());
        long l = System.currentTimeMillis();
        Migemo.loadDictionary(file);
        V2CMain.setMessage("Migemo\u7528\u8f9e\u66f8\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86\uff1a " + (System.currentTimeMillis() - l) + " ms");
        this.setISearchColor(0);
    }

    void startISearch(V2CThreadPanel v2CThreadPanel, boolean bl) {
        V2CThreadPanel v2CThreadPanel2 = this.tpISearchThreadPanel;
        if (v2CThreadPanel2 != null && v2CThreadPanel != v2CThreadPanel2) {
            v2CThreadPanel2.endISearch(false);
        }
        this.tpISearchThreadPanel = v2CThreadPanel;
        JTextField jTextField = this.jtfSearchWords;
        if (bl && !this.bInISearch) {
            bLoadMigemoDictTried = false;
            this.loadMigemoDictionary();
            this.bInMigemo = true;
            jTextField.getInputContext().endComposition();
            jTextField.enableInputMethods(false);
        }
        this.bInISearch = true;
        this.sLastText = jTextField.getText();
        this.setString("", true);
        this.setISearchColor(this.bInMigemo ? 2 : 1);
    }

    void setISearchColor(int n) {
        Color color;
        switch (n) {
            case 1: {
                color = new Color(0xF0FFF0);
                break;
            }
            case 2: {
                color = new Color(0xF0F0FF);
                break;
            }
            case 3: {
                color = new Color(0xFFFFC0);
                break;
            }
            default: {
                color = this.cDefaultBG;
            }
        }
        this.jtfSearchWords.setBackground(color);
    }

    void setNormalColor() {
        this.jtfSearchWords.setBackground(this.bRegExpError ? new Color(0xFF7F7F) : this.cDefaultBG);
    }

    void endISearch(V2CThreadPanel v2CThreadPanel) {
        boolean bl;
        boolean bl2 = bl = v2CThreadPanel == null;
        if (bl ? (v2CThreadPanel = this.tpISearchThreadPanel) == null : v2CThreadPanel != this.tpISearchThreadPanel) {
            return;
        }
        this.tpISearchThreadPanel = null;
        JTextField jTextField = this.jtfSearchWords;
        if (this.bInMigemo) {
            if (!this.bMigemo) {
                jTextField.enableInputMethods(true);
            }
            this.bInMigemo = false;
        }
        this.setString(this.sLastText, true);
        this.bInISearch = false;
        if (bl) {
            v2CThreadPanel.endISearch(false);
        }
        this.setNormalColor();
        if (this.bRegExp) {
            this.checkRegExp();
        } else {
            this.bRegExpError = false;
        }
    }

    void checkISearch() {
        V2CThreadPanel v2CThreadPanel;
        if (this.bInISearch && (v2CThreadPanel = this.tpISearchThreadPanel) != null && v2CThreadPanel != V2CThreadPanel.getActivePanel()) {
            this.endISearch(null);
        }
    }

    void setCondition(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.setCondition(string, bl, bl2, bl3, bl4, false);
    }

    void setCondition(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.setString(string, true);
        this.bCaseSensitive = bl2;
        this.bAnd = bl3;
        this.bOr = !bl3 && bl4;
        this.bMigemo = false;
        this.bMessageBodyOnly = bl5;
        this.setRegExp(bl);
    }

    void setString(String string, boolean bl) {
        this.bIgnoreTextChange = bl;
        InputContext inputContext = this.jtfSearchWords.getInputContext();
        if (inputContext != null) {
            inputContext.endComposition();
        }
        this.jtfSearchWords.setText(string);
        this.bIgnoreTextChange = false;
    }

    String getString() {
        String string = this.getStringForSave();
        if (this.bMigemo) {
            this.loadMigemoDictionary();
            return Migemo.lookup(string);
        }
        return string;
    }

    String getStringForSave() {
        return this.jtfSearchWords.getText();
    }

    void toggleMigemo() {
        boolean bl = this.bMigemo;
        if (!bl && V2CApp.isWinType() && this.jtfSearchWords.hasFocus()) {
            SwingUtilities.invokeLater(new ToggleMigemo());
        } else {
            this.setMigemo(!bl);
        }
    }

    void setMigemo(boolean bl) {
        if (bl == this.bMigemo) {
            return;
        }
        this.bMigemo = bl;
        bLoadMigemoDictTried = false;
        this.setString("", true);
        if (!this.bInISearch) {
            this.jtfSearchWords.enableInputMethods(!bl);
        }
    }

    boolean isMigemo() {
        return this.bMigemo;
    }

    boolean isInMigemoMode() {
        return this.bInISearch ? this.bInMigemo : this.bMigemo;
    }

    void setRegExp(boolean bl) {
        this.bRegExp = bl;
        if (!this.bInISearch && !this.bMigemo) {
            if (bl) {
                this.checkRegExp();
            } else {
                this.bRegExpError = false;
                this.setNormalColor();
            }
        }
    }

    boolean isRegExp() {
        return this.bMigemo ? true : this.bRegExp;
    }

    void setCaseSensitive(boolean bl) {
        this.bCaseSensitive = bl;
    }

    boolean isCaseSensitive() {
        return this.bMigemo ? false : this.bCaseSensitive;
    }

    boolean isAnd() {
        return this.bMigemo ? false : this.bAnd;
    }

    void setAnd(boolean bl) {
        this.bAnd = bl;
        if (bl && this.bOr) {
            this.bOr = false;
        }
    }

    boolean isOr() {
        return this.bMigemo ? false : this.bOr;
    }

    void setOr(boolean bl) {
        this.bOr = bl;
        if (bl && this.bAnd) {
            this.bAnd = false;
        }
    }

    void setMessageBodyOnly(boolean bl) {
        this.bMessageBodyOnly = bl;
    }

    boolean isMessageBodyOnly() {
        return this.bMessageBodyOnly;
    }

    void setRealTime(boolean bl) {
        this.bRealTime = bl;
    }

    boolean isRealTime() {
        return this.bRealTime;
    }

    void requestFocusToTextField() {
        this.jtfSearchWords.requestFocusInWindow();
    }

    void setComponentSize() {
        V2CToolBarComponentSettingPanel v2CToolBarComponentSettingPanel = new V2CToolBarComponentSettingPanel(this.nWidth, this.getMinimumWidth());
        if (!v2CToolBarComponentSettingPanel.showDialog()) {
            return;
        }
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        int n = Math.max(v2CToolBarComponentSettingPanel.getFixedWidth(), this.getMinimumWidth());
        if (n == this.nWidth) {
            return;
        }
        this.nWidth = n;
        v2CProperty.putInt(this.sWidthKey, n);
        this.invalidate();
        V2CToolBar v2CToolBar = (V2CToolBar)SwingUtilities.getAncestorOfClass(V2CToolBar.class, this);
        if (v2CToolBar != null) {
            v2CToolBar.revalidate();
            v2CToolBar.repaint();
        }
    }

    final void filter() {
        if (this.iType == 1) {
            V2CListTable v2CListTable = V2CListTable.getActiveTable();
            if (v2CListTable != null) {
                v2CListTable.filterTitle(this, false, false);
            }
        } else if (this.iType == 2) {
            V2CThreadPanel v2CThreadPanel = V2CThreadPanel.getActivePanel();
            if (v2CThreadPanel != null) {
                v2CThreadPanel.filterRes(this, false, false);
            }
        } else if (this.iType == 3 && this.vDialogBoardList != null) {
            this.vDialogBoardList.filterTitle(this, false, false);
        }
    }

    void resetDisplay() {
        if (this.iType == 1) {
            V2CListTable v2CListTable = V2CListTable.getActiveTable();
            if (v2CListTable != null) {
                v2CListTable.resetDisplay();
            }
        } else if (this.iType == 2) {
            V2CThreadPanel v2CThreadPanel = V2CThreadPanel.getActivePanel();
            if (v2CThreadPanel != null) {
                v2CThreadPanel.resetDisplay();
            }
        } else if (this.iType == 3 && this.vDialogBoardList != null) {
            this.vDialogBoardList.resetDisplay();
        }
    }

    void doWebThreadSearch() {
        if (this.iType != 1) {
            return;
        }
        String string = this.getString();
        if (string.length() == 0) {
            return;
        }
        ArrayList arrayList = V2CWebSearchEntry.getEntries();
        if (arrayList.size() == 0) {
            return;
        }
        V2CWebSearchItem v2CWebSearchItem = V2CWebSearchItem.createItem((V2CWebSearchEntry)arrayList.get(0), string);
        if (v2CWebSearchItem == null) {
            return;
        }
        V2CWebSearchList.openWebSearchList(v2CWebSearchItem, true);
    }

    void findNext(boolean bl) {
        if (this.iType == 0) {
            V2CTree.findNext(this, bl);
        } else if (this.iType == 1) {
            V2CListTable v2CListTable = V2CListTable.getActiveTable();
            if (v2CListTable == null) {
                return;
            }
            v2CListTable.searchTitle(this, bl);
        } else if (this.iType == 2) {
            V2CThreadPanel v2CThreadPanel = V2CThreadPanel.getActivePanel();
            if (v2CThreadPanel == null) {
                return;
            }
            v2CThreadPanel.searchRes(this, bl);
        } else if (this.iType == 3 && this.vDialogBoardList != null) {
            this.vDialogBoardList.searchTitle(this, bl);
        }
    }

    abstract int getMinimumWidth();

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.findNext(mouseWheelEvent.getWheelRotation() > 0);
    }

    void checkRegExp() {
        if (!this.bRegExp) {
            return;
        }
        boolean bl = false;
        String string = this.getString();
        String[] stringArray = V2CMiscUtil.turnStringToArray(string, this.bAnd || this.bOr);
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                try {
                    if (this.bCaseSensitive) {
                        Pattern.compile(string2);
                        continue;
                    }
                    Pattern.compile(string2, 2);
                    continue;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    bl = true;
                    break;
                }
            }
        }
        if (bl != this.bRegExpError) {
            this.bRegExpError = bl;
            this.setNormalColor();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.bIgnoreTextChange) {
            return;
        }
        if (this.nCommittedCharacterCount != this.nCombinedCharacterCount) {
            return;
        }
        if (this.bInISearch) {
            V2CThreadPanel v2CThreadPanel = this.tpISearchThreadPanel;
            if (v2CThreadPanel != null) {
                v2CThreadPanel.iSearchStringChanged(this.jtfSearchWords.getText());
            }
        } else {
            this.checkRegExp();
            if (this.bRealTime && !this.bRegExpError) {
                if (this.iType == 1) {
                    V2CListTable v2CListTable = V2CListTable.getActiveTable();
                    if (v2CListTable != null) {
                        v2CListTable.filterTitle(this, true, true);
                    }
                } else if (this.iType == 2) {
                    V2CThreadPanel v2CThreadPanel = V2CThreadPanel.getActivePanel();
                    if (v2CThreadPanel != null) {
                        v2CThreadPanel.filterRes(this, true, true);
                    }
                } else if (this.iType == 3 && this.vDialogBoardList != null) {
                    this.vDialogBoardList.filterTitle(this, true, true);
                }
            }
        }
    }

    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        this.nCommittedCharacterCount = inputMethodEvent.getCommittedCharacterCount();
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        this.nCombinedCharacterCount = attributedCharacterIterator != null ? attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex() : 0;
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
    }

    public void showPopupMenuByKB(ActionEvent actionEvent) {
        this.mlPopupListener.showPopup(this.jtfSearchWords);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.endISearch(null);
        }
    }

    class PopupListener
    extends V2CPopupListener {
        PopupListener(String string, Component component) {
            super(string, component);
        }

        void setupAction(MouseEvent mouseEvent) {
            V2CAction.setSelected("ToggleRegExp", V2CAbstractMiniSearch.this.bRegExp);
            V2CAction.setSelected("ToggleCaseSens", V2CAbstractMiniSearch.this.bCaseSensitive);
            if (V2CAbstractMiniSearch.this.iType != 0) {
                V2CAction.setSelected("ToggleAndFilter", V2CAbstractMiniSearch.this.bAnd);
                V2CAction.setSelected("ToggleOrFilter", V2CAbstractMiniSearch.this.bOr);
                V2CAction.setSelected("ToggleRealTime", V2CAbstractMiniSearch.this.bRealTime);
            }
            if (V2CAbstractMiniSearch.this.iType == 2) {
                V2CAction.setSelected("ToggleMessageBodyOnly", V2CAbstractMiniSearch.this.bMessageBodyOnly);
                V2CAbstractMiniSearch.this.endISearch(null);
            }
            V2CAction.setSelected("ToggleMigemo", V2CAbstractMiniSearch.this.bMigemo);
            V2CAbstractMiniSearch.this.jtfSearchWords.requestFocusInWindow();
        }
    }

    private class ToggleMigemo
    implements Runnable {
        boolean bFirst = true;

        private ToggleMigemo() {
        }

        public void run() {
            if (this.bFirst) {
                this.bFirst = false;
                V2CAbstractMiniSearch.this.setMigemo(true);
                V2CAbstractMiniSearch.this.setFocusable(true);
                V2CAbstractMiniSearch.this.requestFocusInWindow();
                SwingUtilities.invokeLater(this);
            } else {
                V2CAbstractMiniSearch.this.jtfSearchWords.requestFocusInWindow();
                V2CAbstractMiniSearch.this.setFocusable(false);
            }
        }
    }
}

